#include <bits/stdc++.h>
#define ll long long
#define MAXN 1000005
using namespace std;

template <typename T>
class Fenwick
{
public:
  vector<T> fenw;
  int n;

  Fenwick(int _n) : n(_n)
  {
    fenw.assign(n + 1, 0);
  }

  void modify(int x, T v)
  {
    while (x <= n)
    {
      fenw[x] += v;
      x += x & -x;
    }
  }

  T get(int x)
  {
    T v = 0;
    while (x > 0)
    {
      v += fenw[x];
      x -= x & -x;
    }
    return v;
  }

  T get(int l, int r)
  {
    return get(r) - get(l - 1);
  }

  int find(T k)
  {
    T sum = 0;
    int pos = 0;
    int i = int(log2(fenw.size() - 1));
    while (i >= 0)
    {
      if (pos + (1 << i) < fenw.size() && sum + fenw[pos + (1 << i)] < k)
      {
        sum += fenw[pos + (1 << i)];
        pos += (1 << i);
      }
      i--;
    }
    return pos + 1;
  }
};

struct Query
{
  ll t, k, x;
};

ll a[MAXN], freq[MAXN], tmp[MAXN], freq_tmp[MAXN];
int N, Q;
Query queries[MAXN];
Fenwick<ll> bit_freq(MAXN), bit_sum(MAXN);
unordered_map<ll, int> s2id;
ll id2w[MAXN];

int main()
{
  ios_base::sync_with_stdio(0);
  cin.tie(0);

  cin >> N >> Q;

  for (int i = 1; i <= N; i++)
  {
    cin >> a[i];
    tmp[i] = a[i];
    freq_tmp[a[i]]++;
  }

  set<ll> sums;
  for (int i = 1; i <= N; i++)
  {
    if (freq_tmp[i] > 0)
    {
      sums.insert(i * freq_tmp[i]);
    }
  }

  for (int q = 0; q < Q; q++)
  {
    int t;
    cin >> t;

    if (t == 1)
    {
      ll k;
      cin >> k;
      queries[q] = {t, k, 0};
    }
    else
    {
      ll x, y;
      cin >> x >> y;
      queries[q] = {t, x, y};

      ll old = tmp[x];

      if (old == y)
      {
        continue;
      }

      freq_tmp[old]--;
      if (freq_tmp[old] > 0)
      {
        sums.insert(old * freq_tmp[old]);
      }

      freq_tmp[y]++;
      sums.insert(y * freq_tmp[y]);

      tmp[x] = y;
    }
  }

  int id = 1;
  for (ll s : sums)
  {
    s2id[s] = id;
    id2w[id] = s;
    id++;
  }

  for (int i = 1; i <= N; i++)
  {
    freq[a[i]]++;
  }

  int d = 0;
  for (int i = 1; i <= N; i++)
  {
    if (freq[i] > 0)
    {
      d++;
      ll sum = i * freq[i];
      bit_freq.modify(s2id[sum], 1);
      bit_sum.modify(s2id[sum], sum);
    }
  }

  for (int q = 0; q < Q; q++)
  {
    if (queries[q].t == 1)
    {
      ll k = queries[q].k;
      ll potezi = N - k;

      if (potezi >= d)
      {
        cout << 0 << "\n";
        continue;
      }

      ll ostali = d - potezi;
      ll idx = bit_freq.find(ostali);
      ll freq_pre = bit_freq.get(idx - 1);
      ll sum_pre = bit_sum.get(idx - 1);

      ll res = sum_pre + (ostali - freq_pre) * id2w[idx];
      cout << res << "\n";
    }
    else
    {
      ll x = queries[q].k;
      ll y = queries[q].x;

      ll old = a[x];
      if (old == y)
      {
        continue;
      }

      ll old_sum = old * freq[old];
      bit_freq.modify(s2id[old_sum], -1);
      bit_sum.modify(s2id[old_sum], -old_sum);

      freq[old]--;
      if (freq[old] > 0)
      {
        ll new_sum = old * freq[old];
        bit_freq.modify(s2id[new_sum], 1);
        bit_sum.modify(s2id[new_sum], new_sum);
      }
      else
      {
        d--;
      }

      if (freq[y] > 0)
      {
        ll old_sum = y * freq[y];
        bit_freq.modify(s2id[old_sum], -1);
        bit_sum.modify(s2id[old_sum], -old_sum);
      }
      else
      {
        d++;
      }

      freq[y]++;
      ll new_sum = y * freq[y];
      bit_freq.modify(s2id[new_sum], 1);
      bit_sum.modify(s2id[new_sum], new_sum);

      a[x] = y;
    }
  }
}